@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Usuário
          <small>atualizar</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Usuarios</a></li>
          <li class="active">atualizar</li>
        </ol>
      </section>
    <section class="content">
     

     <!------------------------------------------------------------------------>

     <div class="row">
        @include('partials.validation')  

            <div class="col-md-12">              
         


                    <!-- Horizontal Form -->
                    <div class="box box-info">
                      <div class="box-header with-border">
                        <h3 class="box-title">Altere os dados do usuário</h3>
                      </div>
                      <!-- /.box-header -->
                      <!-- form start -->
                      <form class="form-horizontal" action="{{route('usuario.store')}}" method="POST" enctype="multipart/form-data">
                        <div class="box-body">
                          
                                {{ csrf_field() }}
                           
                          <input type="hidden" name="id" value="">
                         
                 
                          <div class="form-group">
                             <label for="name" class="col-sm-2 control-label">Nome</label>          
                                <div class="col-sm-10">
                                 <input type="text" class="form-control" id="name" name="name"  value="{{old('name')}}">
                              </div>
                          </div> 
                        
    
                         <div class="form-group">
                            <label for="matricula" class="col-sm-2 control-label">Matricula</label>         
                            <div class="col-sm-10"> 
                              <input type="text" class="form-control" id="matricula"  name="matricula" value="{{\App\User::getMatricula()}}">
                            
                            </div>
                          </div>
                          
                        

                          <div class="form-group">
                            <label for="nivel" class="col-sm-2 control-label">Nivel</label> 
                            <div class="col-sm-10">
                            <select  class="form-control" name="nivel" id="nivel">
                                @foreach( \App\User::NIVEL as $key=>$nivel)  
                                     <option value="{{$key}}" {{$key == 2 ? 'selected' : '' }} >{{$nivel}}</option>                               
                                @endforeach
                            </select>
                           </div>
                           </div> 


                             
                           <div class="form-group">
                            <label for="funcao" class="col-sm-2 control-label">Função</label> 
                            <div class="col-sm-10">
                            <select  class="form-control" name="funcao_id" id="funcao_id">
                                @foreach( \App\Funcao::all() as $key=>$funcao)  
                                     <option value="{{$funcao->id}}" >{{$funcao->funcao}}</option>                               
                                @endforeach
                            </select>
                           </div>
                           </div> 
                          
                          
                       <div class="form-group">
                            <label for="cargo" class="col-sm-2 control-label">Tipo Função</label> 
                            <div class="col-sm-10">
                            <select  class="form-control" name="cargo" id="cargo" require>
                                <option value="">SELECIONE</option>
                                @foreach( \App\User::CARGO as $key=>$cargo)  
                                     <option value="{{$key}}">{{$cargo}}</option>                               
                                @endforeach
                            </select>
                           </div>
                           </div>                        
                          



                           <div class="form-group">
                            <label for="setor" class="col-sm-2 control-label">Setor</label> 
                            <div class="col-sm-10">
                            
                            <gs-set-setor setores="{{\App\Setor::all()}}"  setores_user="0"  /></gs-set-setor>

                               
                             </div>
                          </div> 
                         


                        <div class="form-group">
                            <label for="email" class="col-sm-2 control-label">Email</label>          
                            <div class="col-sm-10">
                               <input type="email" class="form-control" id="email" name="email"  value="{{old('email')}}">
                            </div>
                        </div> 




             

                        <div class="form-group">
                            <label for="telefone" class="col-sm-2 control-label">Telefone</label>          
                            <div class="col-sm-10">
                                <input type="tel" class="form-control telefone" id="telefone" name="telefone"  value="{{old('telefone')}}">
                            </div>
                         </div> 


                         <div class="form-group">
                            <label for="id_profissional" class="col-sm-2 control-label">ID Profissional</label>          
                            <div class="col-sm-10">
                               <input type="text" class="form-control" id="id_profissional" require name="id_profissional"  value="{{old('email')}}">
                            </div>
                        </div> 


                         <div class="form-group">
                            <label for="foto" class="col-sm-2 control-label">Obs</label>          
                             <div class="col-sm-10">
                                    <textarea  class="form-control" id="foto" name="obs"  ></textarea>
                             </div>
                        </div> 

                        <div class="form-group">
                                <label for="foto" class="col-sm-2 control-label"></label>          
                                 <div class="col-sm-10">
                                      <gs-image/>
                                 </div>
                            </div> 

                          

                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer">

                           <a href="{{route('usuario.index')}}"  class="btn btn-info pull-right">RETORNAR</a> 

                           @if(Auth::user()->getPermissoes[2]->status == 'ativo')

                             <gs-button  title="Registrar Usúario"  mensagem="Deseja Registar Um Novo Usuario Do Sistema ?" label="CADASTRAR"  status="1" ></gs-button>

                           @endif
                        </div>
                        <!-- /.box-footer -->
                      </form>
                    </div>
                 



        
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->

    
    
    
    
     <!--------------------------------------------------------------------------> 

    </section>
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
  <!-- /.content-wrapper -->

  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
