
@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
   @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Processos
        <small>registrar</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Registrar</a></li>
        <li><a href="#">Processos</a></li>
        <li class="active"></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">

               

        @include('partials.validation')

   
        
        <div class="col-lg-12">


             

        <div class="box  box-info">
              <div class="box-header with-border">
                <h3 class="box-title">Registrar processo</h3>
              </div>

              <form class="form-horizontal" action="{{route('processos.store')}}" method="POST" enctype="multipart/form-data">
              <div class="box-body">
                {{ csrf_field() }}

                 <div class="row">
                  
                    <div class="col-xs-12 col-sm-12 col-md-6 col-lg-8">
                        <!-------------------------------------------->

                        <div class="form-group">
                                  <label for="name" class="col-sm-4 control-label">Solicitante</label>          
                                    <div class="col-sm-8">
                                  
                                   
                                             <gs-seleciona-soliciter soliciter_id='0' style="width:80%;float:left"></gs-seleciona-soliciter>
                                 
                                 
                                             <a href="{{route('solicitante.create')}}" class="btn btn-primary" style="width:20%;float:rigth;;border-radius:0px;-moz-border-radius: 0px;webkit-border-radius: 0
                                             px">ADD</a>
                                    
                                  
                                    
                                  </div>
                                </div>    





                          <div class="form-group">
                            <label for="email" class="col-sm-4 control-label">Usuarios</label>          
                            <div class="col-sm-8">
                                 <input type="text"  class="form-control" value="{{  Auth::user()->name  }}" disabled >
                              
                            </div>
                          </div> 
 

                          <input type="hidden" value="{{  Auth::user()->id  }}" name="usuario_id"  > 

                          <div class="form-group">
                              <label for="email" class="col-sm-4 control-label">Setor</label>          
                              <div class="col-sm-8">

                                <select  class="form-control" name="setor_id" id="setor_id" value="{{old('setor_id')}}">
                                    @foreach (Auth::user()->Setors as $key => $item)
                                        <option value="{{$item->id}}">{{$item->setor}}</option>
                                    @endforeach
                                </select>
                                
               
                              </div>
                            </div> 

                     <!---       
                       <div class="form-group">
                       
                       <gs-permission-process></gs-permission-process>
                       
                       </div>
 -->
                            
    
                              <input type="hidden"  class="form-control"  id="protocolo" name="protocolo" required  value="{{ \App\Process::getNumeroProcesso()}}" >
           
                              <input type="hidden" class="form-control" id="recebimento" name="recebimento"  value="{{\App\Process::getRecebido()}}">
                             
                              <div class="form-group">
                                    <label for="name" class="col-sm-4 control-label">Data Criação</label>          
                                      <div class="col-sm-8">
                                         <gs-data name="criacao" mydate="{{\App\Process::AtualDate()}}"> </gs-data>
                                    </div>
                              </div> 
    
                              <div class="form-group">



                                  <label for="name" class="col-sm-4 control-label">Data Alteração</label>          
                                    <div class="col-sm-8">
                                        <gs-data name="alteracao" mydate="{{         \App\Process::AtualDate()}}   "> </gs-data>
                                  </div>
                              </div> 
                              
                              <div class="form-group">
                                  <label for="name" class="col-sm-4 control-label">Status</label>          
                                    <div class="col-sm-8">
                                        <select  class="form-control" id="status"  disabled value="{{old('status_id')}}">
                                            @foreach (\App\Status::all() as $key => $item)
                                                <option value="{{$item->status}}">{{$item->status}}</option>
                                            @endforeach
                                        </select>

                                        <input type="hidden" value="{{\App\Status::all()[0]->id}}" name="status_id" >
                                    </div>
                                  </div>
                                  
    
                              <div class="form-group">
                                <label for="name" class="col-sm-4 control-label">Prazo</label>          
                                  <div class="col-sm-8">
                                      <gs-data name="prazo" mydate="{{   date('d/m/Y',(strtotime('+30 days')))    }}"> </gs-data>
                                </div>
                              </div> 


                              <div class="form-group">
                                <label for="name" class="col-sm-4 control-label">Espécie</label>          
                                  <div class="col-sm-8">
                                      <select  class="form-control" name="especie" required id="especie" value="{{old('especie')}}">
                                              <option value="Interno">Interno</option>
                                              <option value="Externo">Externo</option>
                                      </select>
                                </div>
                              </div> 




                              <div class="form-group">
                                <label for="name" class="col-sm-4 control-label">Prioridade</label>          
                                  <div class="col-sm-8">



                                      <select  class="form-control" name="prioridade_id" id="prioridade_id" value="{{old('prioridade_id   ')}}">
                                          @foreach (\App\Prioridade::all() as $key => $item)
                                              <option value="{{$item->id}}">{{$item->prioridade}}</option>
                                          @endforeach
                                      </select>
                                </div>
                              </div> 
    
                              <div class="form-group">
                                  <label for="name" class="col-sm-4 control-label">Tipo de Processo</label>          
                                    <div class="col-sm-8">                                      
                                        <select  class="form-control" name="tipo_processo_id" id="tipo_processo_id" value="{{old('tipo_processo_id')}}">
                                           
                                             <option value="{{$item->id}}">SELECIONE O TIPO DE PROCESSO CORRETO LOGO ABAIXO</option>
                                          
                                            @foreach (\App\TipoProcesso::orderBy('tipo')->orderby('tipo','DESC')->get() as $key => $item)
                                                <option value="{{$item->id}}">{{$item->tipo}}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div> 
                             
    
                              
    
                           
    
                        
                       <div class="form-group">
                            <label for="justificativa" class="col-sm-4 control-label">Justificativa</label>          
                            <div class="col-sm-8">
                                 <textarea rows="4" cols="50"   class="form-control"  name="justificativa" id="justificativa" maxlength="900" >
                                 {{old('justificativa')}}
                                 </textarea>

                              
                            </div>
                          </div> 
  
                          <div class="form-group">
                            <label for="amparo_legal" class="col-sm-4 control-label">Amparo Legal</label>          
                            <div class="col-sm-8">
                                 <input type="text"  class="form-control" value="{{old('amparo_legal')}}" name="amparo_legal" id="amparo_legal" maxlength="130" >
                              
                            </div>
                          </div> 

                              
    
                             

                                <div class="form-group">
                                    <label for="name" class="col-sm-4 control-label">Corpo do Processo</label>          
                                      <div class="col-sm-8">                                      
                                     
                                              <textarea rows="4" cols="50"  class="form-control" required  id="obs" name="obs" maxlength="1900">
                                               {{old('obs')}}
                                              </textarea>
                                       </div>
                                  </div> 
      
    
                                @if(Auth::user()->getPermissoes[42]->status == 'ativo')
                                    <div class="form-group">
                                        <label for="name" class="col-sm-4 control-label"></label>          
                                         <div class="col-sm-8">                                      
                                            <div class="checkbox">
                                                <label><input type="checkbox" value="reservado" name="reservado">É reservado ? </label>
                                            </div>
                                        </div>
                                    </div> 
                                 @endif

                        <!-------------------------------------------->

      
                   
                      </div>

                      
                      <div class="col-xs-12 col-sm-12 col-md-6 col-lg-4"  align="center">                        
                           
                                  
                                    <gs-documentos></gs-documentos>
                                  
                                 
                      </div>
                   
                 </div>

               
                      
                       


                  </div>

                  <div class="box-footer">
                      

                    <a href="{{route('processos.index')}}"  class="btn btn-info pull-right">RETORNAR</a> 

                    @if(count(Auth::user()->Setors) > 0)
                             <gs-button  title="Registrar Protocolo"  mensagem="Deseja Registar Um Novo Processo ?" label="CADASTRAR"  status="1" ></gs-button>

                    @endif
                  
                  </div> 
              </form>
            </div>      
                 
         </div> <!-- col -->
       </div>  <!-- row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

 

   


   
   
 


  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
       <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper --> 
     
@endsection
