@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Processos
          <small>listar</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Processos</a></li>
          <li class="active">listar</li>
        </ol>
      </section>
  
  

     <!------------------------------------------------------------------------>

     <section class="content">

     <div class="row">

        



            <div class="col-lg-12">              
               <div class="box box-info">
                 <div class="box-body"> 


                  
                <ul class="nav nav-tabs" role="tablist">
                    <li role="presentation" class="active"><a href="#processos" aria-controls="form" role="tab" data-toggle="tab">Processos</a></li>
                    <li role="presentation"><a href="#meusprocessos" aria-controls="pesquisa" role="tab" data-toggle="tab">Processos do Usuario</a></li>
                

                   
                    @foreach((\App\SetorUser::select('setor','setor_id')->join('setors','setors.id','LIKE','setor_user.setor_id')->
                                where('user_id','LIKE',  Auth::user()->id)->get()) as $setor)
                            
                            
                                <li role="presentation"><a href="#setorprocessos_{{$setor->setor_id}}" aria-controls="pesquisa" role="tab" data-toggle="tab">Processos {{$setor->setor}} </a></li>
      

                    @endforeach


     
                </ul>

                <div class="tab-content">
                      <div role="tabpanel" class="tab-pane active" id="processos">

                            <a href="{{route('processos.index')}}"  class="btn btn-sm btn-danger pull-right" style="margin-right:30px;" data-toggle="tooltip"  data-placement="top" title="Atualizar Sistema"><i class="fa fa-refresh" aria-hidden="true"></i></a>
                            <gs-protocolo style="padding:15px" :id="{{Auth::user()->id}}" setores="{{Auth::user()->Setors}}" nivel="{{Auth::user()->nivel}}" prioridade="{{\App\Prioridade::all()}}"    ></gs-protocolo>
                            @if(Auth::user()->getPermissoes[27]->status == 'ativo')
                            <a href="{{route('processos.create')}}" class="btn btn-primary pull-right" style="margin:5px;width:110px"><b>CADASTRAR</b></a>
                            @endif
                          
                           

                   
                          
                            <a href="{{route('index')}}" class="btn btn-primary pull-right" style="margin:5px;width:110px"><b>SAIR</b></a>

                      </div>


                          
                     

                      <div role="tabpanel" class="tab-pane" id="meusprocessos">

                      <gs-user-protocol process='{{(\App\Process
                                ::join('setors','processes.setor_id','LIKE','setors.id')
                                ->join('soliciters','processes.solicitante_id','LIKE','soliciters.id')
                                ->join('tipo_processos','processes.tipo_processo_id','LIKE','tipo_processos.id')                               
                                ->join('status','processes.status_id','LIKE','status.id')
                                ->join('prioridades','processes.prioridade_id','LIKE','prioridades.id')
                                ->select('processes.id',
                                          'setors.setor',
                                          'status.status',
                                          'prioridades.prioridade',
                                          'tipo_processos.tipo',
                                          'soliciters.nome',
                                          'setors.setor',
                                          'justificativa',
                                          'amparo_legal',
                                          'especie',
                                          'parecer',
                                          'protocolo',
                                          'prazo',
                                          'processes.obs',
                                          'criacao',
                                          'alteracao')
                                ->where('usuario_id','LIKE', Auth::user()->id  )
                                ->get())}}'></gs-user-protocol>   

                        
                     
                      </div>

                      @foreach((\App\SetorUser::select('setor','setor_id')->join('setors','setors.id','LIKE','setor_user.setor_id')->
                                where('user_id','LIKE',  Auth::user()->id)->get()) as $setor)
                     


                      <div role="tabpanel" class="tab-pane" id="setorprocessos_{{$setor->setor_id}}">

                 

                      <gs-user-protocol process='{{(\App\Process
                                ::join('setors','processes.setor_id','LIKE','setors.id')
                                ->join('soliciters','processes.solicitante_id','LIKE','soliciters.id')
                                ->join('tipo_processos','processes.tipo_processo_id','LIKE','tipo_processos.id')                               
                                ->join('status','processes.status_id','LIKE','status.id')
                                ->join('prioridades','processes.prioridade_id','LIKE','prioridades.id')
                                ->select('processes.id',
                                          'setors.setor',
                                          'status.status',
                                          'prioridades.prioridade',
                                          'tipo_processos.tipo',
                                          'soliciters.nome',
                                          'setors.setor',
                                          'justificativa',
                                          'amparo_legal',
                                          'especie',
                                          'parecer',
                                          'protocolo',
                                          'prazo',
                                          'processes.obs',
                                          'criacao',
                                          'alteracao')
                                ->where('setor_id','LIKE', $setor->setor_id  )
                                ->get())}}'></gs-user-protocol>   

                   
                     
                      </div>
                      @endforeach


                      </div>
                    </div>  





                 
                 </div>
               </div>
          
            </div>
         
      </div>
     <!--------------------------------------------------------------------------> 
  
    </section>
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
 

{{------------------------------}}
{{-------------------------------}}




  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
