@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
   @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        Processos
        <small>atualizar</small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Atualizar</a></li>
        <li><a href="#">Processos</a></li>
        <li class="active"></li>
      </ol>
    </section>

    <!-- Main content -->
    <section class="content">
      <div class="row">

               

        @include('partials.validation')


        {!!  isset($protocolo) ? "<div class='col-md-12'><div class='callout callout-success' ><ul><li>Processo Nº $protocolo registrado </li></ul></div></div>" :'' !!}

        

        
        <div class="col-lg-12">






                

             

      

             


<!-------------->



      <div class="nav-tabs-custom">
        <ul class="nav nav-tabs">
          <li class="active"><a href="#tab_1" data-toggle="tab">Dados do Processo</a></li>
          <li><a href="#tab_2" data-toggle="tab">Documentos do Processo</a></li>
          <li><a href="#tab_3" data-toggle="tab">Historico</a></li>
    
          
          
        </ul>


        <div class="tab-content">
          <div class="tab-pane active" id="tab_1">            
              <!---------------------->

              <div class="box  box-info">
                <div class="box-header with-border">
                  <h3 class="box-title">Registrar processo</h3>
                </div>
              <form class="form-horizontal" action="{{route('processos.update',$item->id)}}" method="POST" enctype="multipart/form-data">
                <div class="box-body">
                {{ csrf_field() }}

                 <div class="row">


                        <input type="hidden" value="{{$item->id}}" name="id">
                     
                  
                    <div class="col-xs-12 col-sm-12 col-md-5 col-lg-7">
                        <!-------------------------------------------->


                        
                        <div class="form-group">
                            <label for="email" class="col-sm-4 control-label">Processo</label>          
                            <div class="col-sm-8">
                                 <input type="text"  class="form-control" value="{{ $protocolo = $item->protocolo }}"   >
                                 <input type="text"   name="protocolo" value={{$protocolo}}>
                            </div>
                          </div>     


                          <div class="form-group">
          <label for="name" class="col-sm-4 control-label">Solicitante</label>          
          <div class="col-sm-8">

                    <select  class="form-control"  id="solicitante_id"  disabled value="{{old('solicitante_id')}}">
                        @foreach (\App\Soliciter::all() as $key => $solicitante)
                            <option value="{{$solicitante->id}}" {{$item->solicitante_id == $solicitante->id ? 'selected':'' }} >{{$solicitante->nome}}</option>
                    
                        @endforeach
                    </select>

                 @if(Auth::user()->getPermissoes[43]->status != 'ativo') 
                    @foreach (\App\Soliciter::all() as $key => $solicitante)
                      @if($item->solicitante_id == $solicitante->id)
                        <input type="hidden" value="{{$solicitante->id}}" name="solicitante_id">
                          @break
                      @endif
                    @endforeach
                @endif 

          </div>
      </div>    
    

    @if(Auth::user()->getPermissoes[43]->status == 'ativo')
      <div class="form-group">
        <label for="name" class="col-sm-4 control-label">Alterar Solicitante</label>          
          <div class="col-sm-8">
             <gs-seleciona-soliciter soliciter_id='{{$item->solicitante_id}}'></gs-seleciona-soliciter>
          </div>
      </div>    
    @endif



                         <div class="form-group">
                            <label for="email" class="col-sm-4 control-label">Usuarios</label>          
                            <div class="col-sm-8">
                                 <input type="text"  class="form-control" value="{{  Auth::user()->name  }}" disabled >
                                 <input type="hidden" value="{{  Auth::user()->id  }}" name="usuario_id"  > 
                            </div>
                          </div> 


                    
<div class="form-group">
    <label for="email" class="col-sm-4 control-label">Setor Atual</label>          
    <div class="col-sm-8">
      <select  class="form-control"   value="{{old('setor_id')}}" disabled>
          @foreach (\App\Setor::all() as $key => $setor)
             <option  {{  $setor->id == $item->setor_id ? 'selected':''}}  >{{$setor->setor}}</option>
          @endforeach
      </select>
    </div>
  </div>  

  <div class="form-group">
    <label for="email" class="col-sm-4 control-label">Destino</label>          
    <div class="col-sm-8">
      <gs-origem itens='{{\App\Setor::all()}}' name="setor_id"></gs-origem>
    </div>
  </div> 


      

    <div class="form-group">
        <label for="name" class="col-sm-4 control-label">Data Criação</label>          
          <div class="col-sm-8">

            <div class="input-group date" id="datacriacao">
         
                <input type="text" class="form-control"  value="{{$item->criacao}}" disabled  inputClass="form-control"  ></input>
                <input type="hidden" name="criacao"  class="form-control"  value="{{$item->criacao}}"   inputClass="form-control"  ></input>
              
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-calendar"></span>
                </span>         
              </div>   


            
        </div>
  </div> 

  <div class="form-group">
      <label for="name" class="col-sm-4 control-label">Data Alteração</label>          
        <div class="col-sm-8">
            <div class="input-group date" >
       
                <input type="hidden" value="{{$item->alteracao}}"   class="form-control"  name="alteracao" >
             
              <input type="text" value="{{$item->alteracao}}"   class="form-control"  name="name"  disabled>
              <span class="input-group-addon">
                  <span class="glyphicon glyphicon-calendar" ></span>
              </span>         
            </div>
             

      </div>
  </div> 
  

  <div class="form-group">
      <label for="name" class="col-sm-4 control-label">Status</label>          
        <div class="col-sm-8">
            <select  class="form-control" name="status_id" id="status_id" value="{{old('status_id')}}">
                <option value="{{$item->status_id}}">{{\App\Status::find($item->status_id)->status}}</option>
                @foreach (\App\Status::all() as $key => $status )
                   @if(Auth::user()->getPermissoes[43]->status != 'ativo')                 
                      @if($status->id > 2 &&  $status->id != 4)
                        <option value="{{$status->id}}">{{$status->status}}</option>
                      @endif  
                   @endif
                   @if(Auth::user()->getPermissoes[43]->status == 'ativo')
                      @if($item->status_id ==4)
                         @if($status->id == 1 ||  $status->id == 4)
                           <option value="{{$status->id}}">{{$status->status}}</option>
                         @endif
                      @else
                        @if($status->id > 2)
                          <option value="{{$status->id}}">{{$status->status}}</option>
                        @endif  
                      @endif
                  @endif
                
                @endforeach
            </select>
        </div>
      </div>

 


      <div class="form-group">
        <label for="name" class="col-sm-4 control-label">Prazo</label>          
          <div class="col-sm-8">
              <gs-data name="prazo" mydate="{{$item->prazo}}" :active="false"> </gs-data>
        </div>
      </div> 


      <div class="form-group">
        <label for="name" class="col-sm-4 control-label">Espécie</label>          
          <div class="col-sm-8">
              <select  class="form-control" name="especie" required id="especie" value="{{old('especie')}}">
                      <option value="Interno" {{$item->especie == 'Interno' ? 'selected':'' }}>Interno</option>
                      <option value="Externo" {{$item->especie == 'Externo' ? 'selected':'' }} >Externo</option>
              </select>
        </div>
      </div> 


  <div class="form-group">
    <label for="name" class="col-sm-4 control-label">Prioridade</label>          
      <div class="col-sm-8">
          <select  class="form-control" name="prioridade_id" id="prioridade_id" value="{{old('prioridade_id   ')}}">
              @foreach (\App\Prioridade::all() as $key => $prioridade)
                  <option value="{{$prioridade->id}}" {{$prioridade->id == $item->prioridade_id ? 'selected':'' }} >{{$prioridade->prioridade}}</option>
              @endforeach
          </select>
    </div>
  </div> 

  <div class="form-group">
      <label for="name" class="col-sm-4 control-label">Tipo de Processo</label>          
        <div class="col-sm-8">                                      
            <select  class="form-control" name="tipo_processo_id" id="tipo_processo_id" value="{{old('tipo_processo_id')}}">
                @foreach (\App\TipoProcesso::orderBy('tipo')->get() as $key => $processo)
                    <option value="{{$processo->id}}"   {{$processo->id == $item->tipo_processo_id ? 'selected':'' }}   >{{$processo->tipo}}</option>
                @endforeach
            </select>
        </div>
    </div> 
 

  
 

   

    <div class="form-group">
        <label for="name" class="col-sm-4 control-label">Descrição</label>          
          <div class="col-sm-8">                                      
         
                  <textarea rows="4" cols="50"  class="form-control"  id="obs" name="obs">{{$item->obs}}</textarea>
           </div>
      </div> 


    



<!-------------------------------------------->



</div>


<div class="col-xs-12 col-sm-12 col-md-7 col-lg-5"  align="center">                        

      
        <gs-documentos></gs-documentos>
      
     
</div>

</div>






</div>

<div class="box-footer">






    <a href="{{route('processos.index')}}"  class="btn btn-info pull-right">RETORNAR</a> 

   @if(Auth::user()->getPermissoes[29]->status == 'ativo') 
       <gs-button  title="Atualizar Processo"  mensagem="Deseja Atualizar Os Dados do Processo ?" label="ATUALIZAR"  status="{{  \App\Process::getPermission($item->setor_id) ? 1: 0 }}" ></gs-button>

 
   @endif
   @if(Auth::user()->getPermissoes[29]->status != 'ativo')
       <button  type="button"  disabled  class="btn btn-info pull-right" style="margin-right:5px"> ATUALIZA </button>
   @endif


</div>
</form>

</div>
              <!---------------------->
       
            

          </div>
       
           <div class="tab-pane" id="tab_2">


                
        
       
            <table class="table table-striped table-bordered table-hover table-condensed table-responsive">
                <tr>
                  <th width="90%">Nome Arquivo</th>

                  @if(Auth::user()->getPermissoes[22]->status == 'ativo')
                
                  <th width="5%" class="text-center">Atualiza</th> 
                
                   @endif 
                
                  <th width="5%" class="text-center">Visualizar</th> 
                  @if(Auth::user()->getPermissoes[23]->status == 'ativo')
                
                  <th width="5%" class="text-center">Remover</th> 
                
                  @endif
                
                
                </tr>

      
            @foreach($item->getDocs as $doc)
                <tr>
                  <td>{{$doc->documento}}</td>
                  @if(Auth::user()->getPermissoes[22]->status == 'ativo')
                  <td class="text-center">
                      <gs-dc-update id="{{$doc->id}}" name="{{$doc->documento}}"   >{{    csrf_field() }}</gs-dc-update>
                  </td>
                  @endif
  
                  <td class="text-center">
                    <a href="{{route('documento.edit',$doc->id.'.'.$doc->extencao)}}" target="_black">
                     <i class="fa fa-fw fa-search-plus"></i>
                    </a>
                  </td>
  
                  @if(Auth::user()->getPermissoes[23]->status == 'ativo')
                    <td class="text-center">
                      <gs-dc-remove id="{{$doc->id}}" name="{{$doc->documento}}"   >{{    csrf_field() }} </gs-dc-remove>
                    </td>
                    @endif  

                </tr>
            @endforeach

        </table>
      
           
        
        </div> 
        <!-- /.tab-content -->
   
  



<!------------->

<div class="tab-pane" id="tab_3">


     

       
        <gs-lista nome="{{$solicitante->nome}}" protocolo="{{$protocolo}}"></gs-lista>

         

    


    </div>

</div> 



<!-------------------------->



                       
           
                 
         </div> <!-- col -->
       </div>  <!-- row -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

 

   


   
   
 


  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper --> 
     
@endsection
