<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

//Route::get('/', function () {
  //  return view('welcome');
//});



Route::get('acompanhar', function () {
    return view('acompanhamento.index');
});


Route::get('permissao', function () {
  return view('home');
})->name('permissao');


Route::get('send', function () {
  return view('auth.send');
})->name('send');


Route::get('reset/{token?}', function () {
  return view('auth.reset');
})->name('reset');

Route::get('login', function(){
          return view('auth.login'); 
})->name('login');

Route::post('reset',  'api\Auth\ResetPasswordController@sendEmail')->name('reset.send');
Route::post('update', 'api\Auth\UpdatePasswordController@process')->name('update.send');









Auth::routes();


Route::group(['middleware' => ['auth']], function(){ 
  Route::group(['middleware' => ['check.status']], function(){   

            
            Route::get('/',                             'IndexController@index')->name('index');

            Route::get('usuario',                       'UserController@index')->name('usuario.index');
            Route::get('usuario/cadastrar',             'UserController@create')->name('usuario.create');
            Route::post('usuario/cadastrar',            'UserController@store')->name('usuario.store');
            Route::get('usuario/{id}/selecionar',       'UserController@edit')->name('usuario.edit');
            Route::post('usuario/{id}/atualizar',      'UserController@update')->name('usuario.update');
  
 


            Route::delete('usuario/deletar',            'UserController@destroy')->name('usuario.destroy');
            Route::post('usuario/senha',                'UserController@senha')->name('usuario.senha');

            Route::get('tipocomunicacao',                       'TiposComunicacaoController@index')->name('tipocomunicacao.index');
            Route::get('tipocomunicacao/cadastrar',             'TiposComunicacaoController@create')->name('tipocomunicacao.create');
            Route::post('tipocomunicacao/cadastrar',            'TiposComunicacaoController@store')->name('tipocomunicacao.store');
            Route::get('tipocomunicacao/{id}/selecionar',       'TiposComunicacaoController@edit')->name('tipocomunicacao.edit');
            Route::post('tipocomunicacao/{id}/atualizar',       'TiposComunicacaoController@update')->name('tipocomunicacao.update');
            Route::delete('tipocomunicacao/deletar',            'TiposComunicacaoController@destroy')->name('tipocomunicacao.destroy');
      
            
            Route::get('comunicacao',                       'ComunicacaoController@index')->name('comunicacao.index');
            Route::get('comunicacao/cadastrar',             'ComunicacaoController@create')->name('comunicacao.create');
            Route::post('comunicacao/cadastrar',            'ComunicacaoController@store')->name('comunicacao.store');
            Route::get('comunicacao/{id}/selecionar',       'ComunicacaoController@edit')->name('comunicacao.edit');
            Route::post('comunicacao/{id}/atualizar',       'ComunicacaoController@update')->name('comunicacao.update');
            Route::delete('comunicacao/deletar',            'ComunicacaoController@destroy')->name('comunicacao.destroy');
     
            Route::get('comunicacao/{id}/verifica',         'ComunicacaoController@verifica')->name('comunicacao.verifica');
            
            Route::get('comunicacao/{id}/show',              'DocsComunicacaoController@show')->name('comunicacao.show');
            

           
           
            Route::get('setor',                         'SetorController@index')->name('setor.index');
            Route::get('setor/cadastrar',               'SetorController@create')->name('setor.create');
            Route::post('setor/cadastrar',              'SetorController@store')->name('setor.store');
            Route::get('setor/{id}/selecionar',         'SetorController@edit')->name('setor.edit');
            Route::post('setor/{id}/atualizar',         'SetorController@update')->name('setor.update');
            Route::delete('setor/deletar',              'SetorController@destroy')->name('usuario.destroy');

            Route::get('solicitante',                   'SoliciterController@index')->name('solicitante.index');
            Route::get('solicitante/cadastrar',         'SoliciterController@create')->name('solicitante.create');
            Route::post('solicitante/cadastrar',        'SoliciterController@store')->name('solicitante.store');
            Route::get('solicitante/{id}/selecionar',   'SoliciterController@edit')->name('solicitante.edit');
            Route::post('solicitante/{id}/atualizar',   'SoliciterController@update')->name('solicitante.update');
            Route::delete('solicitante/deletar',        'SoliciterController@destroy')->name('solicitante.destroy');
           
            Route::post('status/cadastrar',             'StatusController@store')->name('status.store');
            Route::post('status/{id}/atualizar',        'StatusController@update')->name('status.update');
       
            Route::post('prioridade/cadastrar',         'PrioridadeController@store')->name('prioridade.store');
            Route::post('prioridade/{id}/atualizar',    'PrioridadeController@update')->name('prioridade.update');

           Route::post('tipo/processo/cadastrar',       'TipoProcessoController@store')->name('tipoprocesso.store');
           Route::post('tipo/processo/{id}/atualizar',  'TipoProcessoController@update')->name('tipoprocesso.update');
           
         
           Route::post('tipo/parecer/cadastrar',       'TipoParecerController@store')->name('tipoparecer.store');
           Route::post('tipo/parecer/{id}/atualizar',  'TipoParecerController@update')->name('tipoparecer.update');
         

         
           Route::get('processos',                     'ProcessosController@index')->name('processos.index');
           Route::get('processos/arquivos',            'ProcessosController@arquivos')->name('processos.arquivos');
           Route::get('processos/reservados',          'ProcessosController@reservados')->name('processos.reservados');
          
           Route::get('processos/cadastrar',           'ProcessosController@create')->name('processos.create');
           Route::post('processos/cadastrar',          'ProcessosController@store')->name('processos.store');
           Route::get('processos/{id}/selecionar',     'ProcessosController@edit')->name('processos.edit');

           Route::get('processos/{id}/desarquivar',    'ProcessosController@desarquivar')->name('processos.desarquivar');
           Route::get('processos/{id}/aceito',         'ProcessosController@setRecebido')->name('processos.aceito');
           Route::post('processos/{id}/atualizar',     'ProcessosController@update')->name('processos.update');


           Route::get('processos/showrelatorio',       'ProcessosController@processosShow')->name('processos.show');

           Route::post('processos/relatorios',         'ProcessosController@processosRelatorios')->name('processos.relatorios');



          
           Route::get('parecer/parecer',                 'ParecerController@index')->name('processos.parecer');
           Route::get('parecer/{id}/visualiza',          'ParecerController@create')->name('parecer.create');
           Route::post('parecer/registra',               'ParecerController@store')->name('parecer.store');
           Route::get('parecer/{id}/seleciona',          'ParecerController@edit')->name('parecer.select');
           Route::post('parecer/{id}/seleciona',         'ParecerController@update')->name('parecer.update');
           Route::get('parecer/{id}/print',              'ParecerController@print')->name('parecer.print');
          
          
           /* Route::delete('solicitante/deletar',     'SoliciterController@destroy')->name('solicitante.destroy');*/
        
           Route::get('process/{id}/processo',         'ProcessosController@getProcessPDF')->name('processos.pdf');
           Route::get('process/{id}/historico',        'ProcessosController@getHistoricoPDF');
           Route::get('process/{id}/evento',           'ProcessosController@getEventoPDF');


           Route::get('documento/{id}/selecionar',     'DocumentoController@show')->name('documento.edit');
           Route::post('documento/{id}/atualizar',     'DocumentoController@update')->name('documento.update');
           Route::post('documento/{id}/remover',       'DocumentoController@remove')->name('documento.remove');




           Route::get('decisao/{id}/visualizar',     'DecisaoFinalController@create')->name('process.decisao'); 

           Route::get('decisao/{id}/seleciona',      'DecisaoFinalController@edit')->name('decisao.select');

           Route::post('decisao/cadastrar',          'DecisaoFinalController@store')->name('decisao.store'); 

           Route::post('decisao/{id}/atualizar',     'DecisaoFinalController@update')->name('decisao.update'); 

        
           Route::get('decisao/{id}/print',          'DecisaoFinalController@print')->name('decisao.print');

       

         
           Route::get('configuracoes', function(){return view('configuracoes.configuracoes');})->name('configuracoes.index');
           Route::get('permissao/{id}/status',     'PermissaoController@edit')->name('status.permissao');      

           
           Route::get('docsparecer/selecionar',       'ParecerController@getDocs')->name('docsParecer.show');
           Route::get('docsparecer/remover',          'ParecerController@removeDocs')->name('docsParecer.remove');
           //Route::post('docsparecer/{id}/atualizar',  'DocsParecerController@updade')->name('docsParecer.update');
           
           Route::post('docsparecer/{id}/atualizar', function(){ dd( 'teste');   } )->name('docsParecer.update');
           
           
           
           Route::get('docsdecisao/selecionar',    'DecisaoFinalController@getDocs')->name('docsDescisao.show');
           Route::get('docsdecisao/remover',       'DecisaoFinalController@removeDocs')->name('docsDescisao.remove');
           Route::post('docsdecisao/{id}/atualizar',    'DocsParecerController@update')->name('docsDescisao.update');
           
          });
       });
             