@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Setores
          <small>cadastrados</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Setores</a></li>
          <li class="active">Listar</li>
        </ol>
      </section>
 


     
        <!-- Main content -->
       
     <!------------------------------------------------------------------------>
     <section class="content">
         <div class="row">    
        
           

            @foreach($setores as $setor) 
                 <div class="col-xs-12 col-sm-6 col-md-4 col-lg-4">

                   
              
                    <gs-card-setor setor ="{{$setor}}" usuario="{{$setor->Users}}" atualiza="{{Auth::user()->getPermissoes[8]->status == 'ativo' ? 1:0 }}" />


               
          
                </div>
            @endforeach
          </div>      
                    
                       
          <nav aria-label="..." class="text-center">
              {!! $setores->render() !!}

          </nav>


      


        @if(Auth::user()->getPermissoes[7]->status == 'ativo')
            <a href="{{route('setor.create')}}" style="margin-left: 10px" class="btn btn-primary pull-right"><b>CADASTRAR</b></a>
        @endif
            <a href="{{route('index')}}" class="btn btn-primary  pull-right" ><b>CANCELAR</b></a>

      
      </section>
        
   
     <!--------------------------------------------------------------------------> 
   
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
  <!-- /.content-wrapper -->

  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
