
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

window._ = require('lodash')


require('./bootstrap');

require('pusher-js');


window.Vue = require('vue');

import Vuex from 'vuex'

Vue.use(Vuex)

import VuexStore from './store/index'


const store  = new Vuex.Store(VuexStore)


Vue.component('GsImage'                 , require('./components/GsImage/GsImage.vue'));
Vue.component('GsCardUser'              , require('./components/GsCardUser/GsCardUser.vue'));
Vue.component('GsCardSetor'             , require('./components/GsCardSetor/GsCardSetor.vue'));
Vue.component('GsSetSetor'              , require('./components/GsSetSetor/GsSetSetor.vue'));
Vue.component('GsSetUser'               , require('./components/GsSetUser/GsSetUser.vue'));
Vue.component('GsCardSoliciter'         , require('./components/GsCardSoliciter/GsCardSoliciter.vue'));
Vue.component('GsCadastraStatus'        , require('./components/GsStatus/GsCadastra/GsCadastra.vue'));
Vue.component('GsStatus'                , require('./components/GsStatus/GsSeleciona/GsSelecionaStatus.vue'));
Vue.component('GsCadastraPrioridade'    , require('./components/GsPrioridade/GsCadastra/GsCadastraPrioridade.vue'));
Vue.component('GsPrioridade'            , require('./components/GsPrioridade/GsSeleciona/GsSelecionaPrioridade.vue'));
Vue.component('GsCadastraTipoProcesso'  , require('./components/GsTipoProcesso/GsCadastra/GsCadastraTipoProcesso.vue'));
Vue.component('GsTipoProcesso'          , require('./components/GsTipoProcesso/GsSeleciona/GsSelecionaTipoProcesso.vue'));
Vue.component('GsCadastraTipoParecer'  , require('./components/GsTipoParecer/GsCadastra/GsCadastraTipoParecer.vue'));
Vue.component('GsTipoParecer'          , require('./components/GsTipoParecer/GsSeleciona/GsSelecionaTipoParecer.vue'));
Vue.component('GsDocumentos'           , require('./components/GsDocumentos/GsDocumentos.vue'));
Vue.component('GsDcUpdate'             , require('./components/GsDocumentos/GsUpdate.vue'));
Vue.component('GsDcRemove'             , require('./components/GsDocumentos/GsRemove.vue'));

Vue.component('GsData'                 , require('./components/GsData/GsData.vue'));
Vue.component('GsSelecionaSoliciter'   , require('./components/GsCardSoliciter/GsSeleciona/GsSeleciona.vue'));
Vue.component('GsOrigem'               , require('./components/GsOrigem/GsOrigem.vue'));
Vue.component('GsAddParecer'           , require('./components/GsParecer/GsAddParecer/GsAddParecer.vue') )/
Vue.component('GsSenha'                , require('./components/GsSenha/GsSenha.vue'));
Vue.component('GsPopUp'                , require('./components/GsPopUp/GsPopUp.vue'));
Vue.component('GsProcessoCard'         , require('./components/GsProcesso/GsCard/GsCard.vue'));


Vue.component('GsRastreamento'         , require('./components/GsRastreamento/GsRastreamento.vue'));


Vue.component('GsProtocolo'            , require('./components/api/GsProcessos/GsLista/GsLista.vue'));
Vue.component('GsPermissoes'           , require('./components/api/GsPermissao/GsPermissao.vue'));


Vue.component('GsAcompanhamento'       , require('./components/api/GsAcompanhemento/GsFormulario.vue'));

Vue.component('GsLista'                , require('./components/api/GsAcompanhemento/GsLista.vue'));


Vue.component('GsDocsParecer'          , require('./components/api/GsDocsParecer/GsDocsParecer.vue'));

Vue.component('GsDocsDecisao'          , require('./components/api/GsDocsDecisao/GsdocsDecisao.vue'));


Vue.component('GsButton'               , require('./components/GsButton/GsButton.vue'));

Vue.component('GsReceptores'           , require('./components/GsReceptores/GsReceptores.vue'));

Vue.component('GsPaginateCi'           , require('./components/api/GsPaginateCi/GsPaginateCi.vue'));

Vue.component('GsCadastraTipoCi'       , require('./components/GsTipoCi/GsCadastra/GsCadastraTIpoCi.vue'));
Vue.component('GsSelecionaTipoCi'      , require('./components/GsTipoCi/GsSeleciona/GsSelecionaTipoCi.vue'));

Vue.component('GsPermissionProcess'    , require('./components/api/GsProcessPermission/GsProcessPermission.vue'));

Vue.component('GsEvent'                , require('./components/api/GsEvent/GsEvent.vue'));

Vue.component('GsUserProtocol'         , require('./components/GsUserProtocol/GsUserProtocol.vue'));

Vue.component('GsNotification'         , require('./components/GsNotification/GsNotification.vue'));

Pusher.logToConsole = false;

var pusher = new Pusher('bce2af5590dc994ae9e6', {
  cluster: 'us2'
});

var channel = pusher.subscribe('Notification');



channel.bind('NotificationEvent', function(data) {
    app.$store.dispatch('notification/notification',data)
});


channel.bind('ProcessNotificationEvent', function(data) {
  app.$store.dispatch('notification/process',data)
});



const app = new Vue({
    el: '#app',
    store
});


