
import {http} from '../http/http.js'


export const listar = (state,data) => {
   http.get(`api/v1/processos?status=${data.status}&user_id=${data.user_id}`).then((response)=>{
        state.commit('setItens',response.data )   
    })
}

export const seleciona = (state,data) => {
    http.get('api/v1/processos/'+ data).then((response)=>{

     
        state.commit('setItem',response.data || {})    
    })
}

export const atualiza = (state,data) => {
     http.put(`api/v1/processos/${data.id}`,data).then((response)=>{  
        state.commit('setFlag',{'show':true,'titulo':'Aviso:','mensagem':'Produto atualizado !'})
    }).catch(function(data){
        state.commit('setFlag',{'show':true,'titulo':'Aviso:','mensagem':'Houve um erro ao atualizar produto !'})
    })  
}

export const cadastra = (state,data) => {
    http.post('api/v1/processos',data).then((response)=>{
        state.commit('setFlag',{'show':true,'titulo':'Aviso:','mensagem':'Novo produto cadastrado !'})    
    }).catch(function(data){
        state.commit('setFlag',{'show':true,'titulo':'Aviso:','mensagem':'Houve um erro ao cadastrar produto !'})
    })
}

export const remove = (state,data) => {
    http.delete('api/v1/processos/'+ data.id).then((response)=>{
           state.commit('setFlag')
    })
}

export const add = (state,data) =>{
     state.commit('addItens',data)  
}