@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Usuário
          <small>atualizar</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Usuarios</a></li>
          <li class="active">atualizar</li>
        </ol>
      </section>
    <section class="content">
     

     <!------------------------------------------------------------------------>

     <div class="row">

        <div class="col-md-12"> 


            @include('partials.validation')

        <div class="col-md-4">


            <div>

                <!-- Nav tabs -->
                <ul class="nav nav-tabs" role="tablist">
                  <li role="presentation" class="active"><a href="#home" aria-controls="home" role="tab" data-toggle="tab">Informações</a></li>
                  @if(Auth::user()->getPermissoes[4]->status == 'ativo')
                      <li role="presentation"><a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">Permissões</a></li>
                  @endif
                </ul>
              
                <!-- Tab panes -->
                <div class="tab-content">
                  <div role="tabpanel" class="tab-pane active" id="home">
                      <!-- Profile Image -->
                      <div class="box box-info">
                        <div class="box-body box-profile">
                          <img class="profile-user-img img-responsive img-circle" src="/images/users/{{$user->id}}.jpg" alt="{{$user->name}}">
                          <h3 class="profile-username text-center">{{$user->name}}</h3>
                          <p class="text-muted text-center">{{$user->matricula}}</p>
                          <ul class="list-group list-group-unbordered">
                              @foreach($user->Setors as $key=>$setor) 
                                <li class="list-group-item">
                                  <b>{{$key+1}}º Setor:</b> <a class="pull-right">{{$setor->setor}}</a>
                                </li>
                              @endforeach
                            <li class="list-group-item">
                              <b>Email:</b> <a class="pull-right">{{$user->email}}</a>
                            </li>
                            <li class="list-group-item">
                              <b>Telefone:</b> <a class="pull-right">{{$user->telefone}}</a>
                            </li>
            
                            <li class="list-group-item">
                                <b>Obs:</b>{{$user->obs}}
                            </li>
      
                          </ul>
      
                          <div >
                          @if(Auth::user()->getPermissoes[5]->status == 'ativo') 
                            <form action="{{route('usuario.senha')}}" method="POST">
                            <gs-senha>
                                <span>
                                  
                                    {{ csrf_field() }}
                                     
                                    <input type="hidden" value="{{$user->id}}" name="id">
      
                                    <label for="senha">Senha:</label>
                                    <input type="text" class="form-control " id="senha" name="senha"  value="{{old('senha')}}">
         
                                    <label for="senha">Confirma Senha:</label>
                                    <input type="text" class="form-control " id="confirma_senha" name="confirma_senha"  value="{{old('confirma_senha')}}">
         
                                  </span>  
                             </gs-senha>
                            </form> 
                          @endif
                          </div>
                    
                         </div>
                         <!-- /.box-body -->
                      </div>
                      <!-- /.box -->

                  </div>
                 @if(Auth::user()->getPermissoes[4]->status == 'ativo')
                   <div role="tabpanel" class="tab-pane" id="profile">
                     <gs-permissoes :id="{{$user->id}}"></gs-permissoes>
                   </div>
                 @endif  
                </div>              
              </div>

            </div>
            <div class="col-md-8">    


             <!-- Nav tabs -->
                <ul class="nav nav-tabs" role="tablist">
                    <li role="presentation" class="active"><a href="#form" aria-controls="form" role="tab" data-toggle="tab">Dados</a></li>
                    <li role="presentation"><a href="#pesquisa" aria-controls="pesquisa" role="tab" data-toggle="tab">Processos Criados</a></li>
                </ul>
                     




                    <!-- Horizontal Form -->



                    <div class="tab-content">
                      <div role="tabpanel" class="tab-pane active" id="form">


                          @include('user.partials.form')

                      </div>
                      <div role="tabpanel" class="tab-pane" id="pesquisa">
       
                            @include('user.partials.process')
                     
                      </div>
                  
                      </div>
        </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->

    
    
    
    
     <!--------------------------------------------------------------------------> 

    </section>
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
  <!-- /.content-wrapper -->

  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
