@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Solicitantes
          <small>cadastrados</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Solicitantes</a></li>
          <li class="active">Listar</li>
        </ol>
      </section>
 


            <!-- Main content -->
       
     <!------------------------------------------------------------------------>
     <section class="content">
         <div class="row">    
          <div class="col-lg-12">    

            <div class="box box-info">

                <br>
                      <div class="col-lg-12">
                          <form action="{{route('solicitante.index')}}" class="form-horizontal" method="get"> 
                              <div class="form-group">    
                                  <label for="serch" class="col-lg-1 control-label">Pesquisar</label>          
                                  <div class="col-lg-11">
                                    <input type="text" class="form-control" name="search">
                                  </div>
                              </div>
                          </form>
                      </div>
                  <br>

                  <div class="box-body">

          <table  class="table table-bordered table-hover">
            <thead>
            <tr>
              <th>Solicitante:</th>
            
              <th width="15%" class="text-center" colspan="2"></th>
           
             
            </tr>
            </thead>
            <tbody>
             
              @foreach ($itens as $key => $item)
              
              <tr>
              
               <td>{{$item->nome}}</td>
            
               
              

             
               
                
                  <td>
                     
                
                    @if(Auth::user()->getPermissoes[13]->status == 'ativo')   
                      <gs-pop-up id="{{$key}}" titulo="Visualizar Solicitante">
                           <gs-card-soliciter item="{{\App\Soliciter::find($item->id)}}"  tipo="{{\App\Soliciter::find($item->id)->tipo_pessoa}}"  />
                      </gs-pop-up>      
                    @endif
                   </td>
                   <td>  
                    @if(Auth::user()->getPermissoes[12]->status == 'ativo')   
                        <a href="{{route('solicitante.edit',$item->id)}}" class="btn btn-xs btn-primary pull-right  btn-atualizar"><b>ATUALIZAR</b></a>
                    @else
                        <a href="#" disabled class="btn btn-xs btn-primary pull-right  btn-atualizar"><b>ATUALIZAR</b></a>
                    @endif
                      
                      </td>
                </tr>   
              @endforeach

          
            </tbody>
           
          </table>


              
        </div>
    


           
                        <nav aria-label="..." class="text-center">
              {!! $itens->render() !!}

          </nav>

         

      </div>
          <div class="row">
            <div class="col-md-12">
        @if(Auth::user()->getPermissoes[11]->status == 'ativo')
              <a href="{{route('solicitante.create')}}" style="width:120px;margin-left:10px " class="btn btn-primary pull-right "><b>CADASTRAR</b></a>
        @endif
              <a href="{{route('index')}}" style="width:120px;margin-left:10px " class="btn btn-primary pull-right "><b>SAIR</b></a>
            </div>                 
          </div>

      </div>
    </div>
      </section>
        
 

     <!--------------------------------------------------------------------------> 
   
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
  <!-- /.content-wrapper -->

  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
