@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
  @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <section class="content-header">
        <h1>
          Socicitante
          <small>Cadastrar</small>
        </h1>
        <ol class="breadcrumb">
          <li><a href="#"><i class="fa fa-dashboard"></i> Solicitante</a></li>
          <li class="active">cadastrar</li>
        </ol>
      </section>
    <section class="content">
     

     <!------------------------------------------------------------------------>

     <div class="row">

            @include('partials.validation')
            <div class="col-md-12">              
           
               <!------------------------------->

               <!-- Horizontal Form -->
               <div class="box box-info">
                 <div class="box-header with-border">
                   <h3 class="box-title">Cadastrar dados do solicitante</h3>
                 </div>
                 <!-- /.box-header -->
                 <!-- form start -->
                 <form class="form-horizontal" action="{{route('solicitante.store')}}" method="post" enctype="multipart/form-data">
                   <div class="box-body">
                     
                           {{ csrf_field() }}
                      

                     <input type="hidden" name="id" value="">


                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Nome</label>          
                           <div class="col-sm-10">
                            <input type="text" class="form-control" id="nome" name="nome"  value="{{old('nome')}}">
                         </div>
                     </div> 

                     
                   


                 


                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Situação</label>          
                           <div class="col-sm-10">
                    
                           <select name="situacao" id="situacao" class="form-control" value="{{old('pessoa')}}">
                           <option  value="">Selecione</option>
                            
                            <option value="Servidor em Atividade">Servidor em Atividade</option>
                            <option value="Servidor Inativo">Servidor Inativo</option>
                            <option value="Empresa Em Atividade">Empresa Em Atividade</option>
                            <option value="Empresa Inativa">Empresa Inativa</option>
                            <option value="Pessoa Fisica - Cidadão">Pessoa Fisica - Cidadão</option>
                            
                      </select>
                         </div>
                     </div> 


                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Lotação</label>          
                           <div class="col-sm-10">
                            <input type="text" class="form-control" id="lotacao" name="lotacao"  value="{{old('lotacao')}}">
                         </div>
                     </div> 

                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Cargo</label>          
                           <div class="col-sm-10">
                            <input type="text" class="form-control" id="cargo" name="cargo"  value="{{old('cargo')}}">
                         </div>
                     </div> 

                     <div class="form-group">
                        <label for="name" class="col-sm-2 control-label">Local De Trabalho</label>          
                           <div class="col-sm-10">
                            <input type="text" class="form-control" id="local_de_trabalho" name="local_de_trabalho"  value="{{old('lotacao')}}">
                         </div>
                     </div> 



                     <div class="form-group">
                      <label for="matricula" class="col-sm-2 control-label">Matricula</label>          
                         <div class="col-sm-10">
                          <input type="text" class="form-control"  id="matricula" name="matricula"  maxlength="15"  value="{{old('matricula')}}">
                       </div>
                   </div> 



                   <input type="hidden" class="form-control" id="matricula" name="matricula"  value="{{ \App\Soliciter::getMatricula() }}">
                  

                   <div class="form-group">
                    <label for="pessoa" class="col-sm-2 control-label">Tipo de Documento</label>          
                    <div class="col-sm-10">
                       

                      <select name="pessoa" id="pessoa" class="form-control" value="{{old('pessoa')}}">
                              @foreach( \App\Soliciter::PESSOA as  $key=>$pessoa)
                                   <option value="{{$key}}">{{$pessoa}}</option>
                              @endforeach                     
                      </select>



                    </div>
                 </div> 
                       
                 <div class="form-group">
                  <label for="documento" class="col-sm-2 control-label" maxlength="18">CPF/CNPJ</label>          
                  <div class="col-sm-10">
                      <input type="tel" class="form-control" id="documento" name="documento" maxlength="18"  value="{{old('documento')}}">
                  </div>
               </div> 

               <div class="form-group">
                  <label for="rg" class="col-sm-2 control-label">RG/IE</label>          
                  <div class="col-sm-10">
                      <input type="tel" class="form-control" id="rg" name="rg"  value="{{old('rg')}}">
                  </div>
               </div> 

                  
                   <div class="form-group">
                      <label for="telefone" class="col-sm-2 control-label">Telefone</label>          
                      <div class="col-sm-10">
                          <input type="tel" class="form-control" id="telefone" name="telefone"  value="{{old('telefone')}}">
                      </div>
                   </div> 

                   <div class="form-group">
                       <label for="email" class="col-sm-2 control-label">Email</label>          
                       <div class="col-sm-10">
                          <input type="text" class="form-control" id="email" name="email"  value="{{old('email')}}">
                       </div>
                   </div> 

                 

                    <div class="form-group">
                       <label for="foto" class="col-sm-2 control-label">Obs:</label>          
                        <div class="col-sm-10">
                               <textarea  class="form-control" id="foto" name="obs"  value=""></textarea>
                        </div>
                   </div> 
{{--
                   <div class="form-group">
                           <label for="foto" class="col-sm-2 control-label"></label>          
                            <div class="col-sm-10">
                                 <gs-image/>
                            </div>

                   
                       </div> 
--}}



                   </div>
                   <!-- /.box-body -->
                   <div class="box-footer">

                      <a href="{{route('solicitante.index')}}"  class="btn btn-info pull-right">RETORNAR</a> 
                      @if(Auth::user()->getPermissoes[11]->status == 'ativo')   
               
                           <gs-button  title="Registrar Solicitante"  mensagem="Deseja Registar Um Novo Solicitante ?" label="CADASTRAR"  status="1" ></gs-button>

                      @endif
                   </div>
                   <!-- /.box-footer -->
                 </form>
               </div>
            








               <!------------------------------->

        
            </div>
        <!-- /.col -->
      </div>
      <!-- /.row -->

    
    
    
    
     <!--------------------------------------------------------------------------> 

    </section>
    <!-- /.content -->
  </div>
    <!-- /.content-wrapper -->

  
  <!-- /.content-wrapper -->

  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper -->
     
@endsection
