@extends('layouts.master')

@section('content')

<!-- Site wrapper -->
<div class="wrapper">

   @include('partials.header')
  <!-- =============================================== -->
   @include('partials.aside')
  <!-- =============================================== -->

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
          
        Processos
        <small>Definir   <small> Parecer</small>   </small>
      </h1>
      <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Definir</a></li>
        <li><a href="#">Parecer</a></li>
        <li class="active"></li>
      </ol>
    </section>

    <!-- Main content -->
     
    <section class="content">
    
                  

      <div class="row">

               

        @include('partials.validation')









   
        
        <div class="col-lg-12">






             
   


<!-------------->
            
              <!---------------------->

              <div class="box  box-info" >
                <div class="box-header with-border">
                  <h3 class="box-title">Definir Parecer</h3>
                </div>







<!---------------------------------------->



                        <div class="box-body">
                         
          
                        <table class="table">
    
   
        @foreach  ($response as $parecer)


        <thead>
        <tr>
           <th colspan="8">
           <hr>
             <h3>ID/{{str_pad($parecer->id, 6, "0", STR_PAD_LEFT)}} - {{$parecer->titulo}}</h3>
           </th>
        </tr>

      <tr>
      <th>Processo</th>
        <th>Data</th>
        
        <th>Status</th>
        <th>Setor</th>
        <th>Usuario</th>
        <th>Solicitante</th>
        <th  width="5%" class="text-center" ><i class="fa fa-refresh" aria-hidden="true"></th>
        <th  width="5%" class="text-center"><i class="fa fa-print" aria-hidden="true"></i></th>
       
      </tr>
    </thead>

        <tbody>
              <tr>
            
                <td>{{ $parecer->protocolo }}</td>
                <td>{{ \Carbon\Carbon::parse($parecer->data)->format('d/m/Y')  }}</td>
                <td>{{ $parecer->tipo }}</td>
                <td>{{ $parecer->setor }}</td>
                <td>{{ $parecer->name }}</td>
                <td>{{ $parecer->nome }}</td>
                <td width="5%"  class="text-center" ><a href="{{route('parecer.select',$parecer->id)}}" class="btn btn-block"><i class="fa fa-refresh" aria-hidden="true"></i></a></td>
                <td width="5%"  class="text-center"><a href="{{route('parecer.print',$parecer->id)}}" target="_blank"  class="btn btn-block"><i class="fa fa-print" aria-hidden="true"></i></a></td>
              
              
              </tr>    
              </tbody>
              <thead>
                  <tr>
                    <th colspan="8">Parecer</th>
                    
                  </tr>
              </thead>
              <tbody>   
                <tr>
                  <td colspan="8">{{ ($parecer->parecer) }}</td>
                </tr>  
              </tbody>

              @if (count($parecer->docs) > 0) 

              <thead>
                  <tr>
                    <th colspan="8">Documentos</th>
                    
                  </tr>
              </thead>

              <tbody>   


            

              @foreach  ($parecer->docs as $doc)
                
                
                
                <tr>
                  <td colspan="8">
                   <a href="{{route( 'docsParecer.show', [ 'id' => $doc->id , 'extencao' => $doc->extencao]   )}}"   target="_blank"   class="list-group-item" >
                                          <i class="fa fa-eye"></i><span> {{    $doc->name      }}</span></a>
 
                   </a>
                  </td>

                </tr>  

               
              
              
              @endforeach
              
              </tbody>
              @endif 

         
          @endforeach
   
  </table>




  <div class="row">

  <hr>

  <a href="{{route('parecer.create',['id'=>$id])}}" target="_self" style="margin-left:0px;margin-right:15px;width:100px"  class="btn btn-success pull-right" rel="noopener noreferrer" {{(\App\Process::findOrFail($id)->status_id == 1 ? '':'disabled')}}  > REGISTAR </a>
  <a href="{{route('processos.index')}}" target="_self" style="margin-left:0px;margin-right:15px;width:100px"  class="btn btn-success pull-right" rel="noopener noreferrer"> RETORNAR </a>
  



</div>
</div> 


<!-------------------------->

 
                       
           
                 
         </div> <!-- col -->
       </div>  <!-- row -->

      
                    
    </section>

   
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->

 

   


   
   
 


  @include('partials.footer')

  @include('partials.disade')


  
  <!-- /.control-sidebar -->
  <!-- Add the sidebars background. This div must be placed
       immediately after the control sidebar -->
  <div class="control-sidebar-bg"></div>
</div>
<!-- ./wrapper --> 
     
@endsection
