<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateArquivosMensagensTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('arquivos_mensagens', function (Blueprint $table) {
            $table->increments('id');

            $table->integer('mensagem_id')->unsigned(); 
            $table->foreign('mensagem_id')->references('id')->on('receptores')->onDelete('cascade');
            $table->string('nome',100)->nullable();
            $table->string('extencao',5)->nullable();
            $table->timestamps();
        
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('arquivos_mensagens');
    }
}
