<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSolicitersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('soliciters', function (Blueprint $table) {
            $table->increments('id')->unsigned();
            $table->string('nome',100);
            $table->string('telefone',15)->nullable();
            $table->string('email',60)->nullable();
            $table->string('documento',18)->nullable();
            $table->string('rg',18)->nullable();
            $table->string('matricula',15)->nullable();
            $table->string('pessoa',15);
            $table->text('obs')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('soliciters');
    }
}
