<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id')->unsigned();


            $table->integer('funcao_id')->unsigned();
            $table->foreign('funcao_id')->references('id')->on('funcoes'); 


            $table->string('matricula',15)->unique();
            $table->ENUM('nivel' ,array_keys(\App\User::NIVEL))->default(2);
            $table->ENUM('status',array_keys(\App\User::STATUS))->default(1);
            $table->ENUM('cargo' ,array_keys(\App\User::CARGO))->default(2);
           
            $table->string('name',100);
            $table->string('email',60)->unique();
            $table->string('password');
            $table->string('telefone',15)->nullable(); 
            $table->string('id_profissional',60)->nullable();
            $table->text('obs')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
