<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Soliciter extends Model
{
    

    protected $table    = 'soliciters';

    protected $fillable = [
        'nome',
        'lotacao',
        'cargo',
        'local_de_trabalho',
        'situacao',
        'telefone',
        'email',
        'documento',
        'rg',
        'matricula',
        'pessoa',
        'obs',
    ];

    const PESSOA = [
        1 => 'Pessoa física',
        2 => 'Pessoa Jurídica'
    ];

//    public function Setores(){
      //  return $this->belongsTo('App\Cliente','cliente_id','id');
 // }

    public function getTipoPessoaAttribute(){
        return $this->pessoa == 1 ? 'Física' : 'Jurídica';
    }



    public static function getMatricula(){
          
        $characters01 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $characters02 = '0123456789';
      
        $randstring01='';
        $randstring02='';

        for ($i=0; $i<4; $i++) {
            $randstring01 .= $characters01[rand(0, strlen($characters01)-1)];
        }
        
        for ($i=0; $i < 10; $i++) {
            $randstring02 .= $characters02[rand(0, strlen($characters02)-1)];
        }

        return $randstring01 . '-'  . $randstring02;
    }
   
}
