<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class ValidaDocumento implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */

    private $tipo=''; 

    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
     
        

        $value = str_replace(['.','/','-',' '],'',$value);

       

        switch(strlen($value))
        {
            case 0:
               return true;
               break; 
            case 11:
              $this->tipo = 'CPF';
              return $this->validaCPF($value);
              break;
            case 14:
              $this->tipo = 'CNPJ';
              return  $this->validaCNPJ($value);
              break;
            default:
              $this->tipo = 'Documento';
              return false;            
            
        }
      
       
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
       return  $this->tipo . ' é invalido';
    }

    private function validaCPF($value){


        if($value == '00000000000' ||
           $value == '11111111111' ||
           $value == '22222222222' ||
           $value == '33333333333' ||
           $value == '44444444444' ||
           $value == '55555555555' ||
           $value == '66666666666' || 
           $value == '77777777777' ||
           $value == '88888888888' ||
           $value == '99999999999')
           {
               return false;
           } 

        $value = str_split($value);
       
        
       $primeiro =
       (($value[0] * 10 
       + $value[1] * 9 
       + $value[2] * 8 
       + $value[3] * 7
       + $value[4] * 6
       + $value[5] * 5
       + $value[6] * 4
       + $value[7] * 3
       + $value[8] * 2 ) * 10) % 11;
       
       if($primeiro == 10){
            $primeiro = 0;
       }

       if($primeiro != $value[9]){
            return false;
       }


       $segundo =
       (($value[0] * 11 
       + $value[1] * 10 
       + $value[2] * 9 
       + $value[3] * 8
       + $value[4] * 7
       + $value[5] * 6
       + $value[6] * 5
       + $value[7] * 4
       + $value[8] * 3
       + $value[9] * 2 ) * 10) % 11;

       if($segundo != $value[10]){
          return false;
       } 

       return true;

    }    

    private function validaCNPJ($value){

        
        if($value == '00000000000000' ||
           $value == '11111111111111' ||
           $value == '22222222222222' ||
           $value == '33333333333333' ||
           $value == '44444444444444' ||
           $value == '55555555555555' ||
           $value == '66666666666666' || 
           $value == '77777777777777' ||
           $value == '88888888888888' ||
           $value == '99999999999999')
           {
               return false;
           } 


           $value = str_split($value);
       
        
           $primeiro =
           ( $value[0] * 5 
           + $value[1] * 4 
           + $value[2] * 3 
           + $value[3] * 2
           + $value[4] * 9
           + $value[5] * 8
           + $value[6] * 7
           + $value[7] * 6
           + $value[8] * 5
           + $value[9] * 4
           + $value[10] * 3
           + $value[11] * 2
           ) % 11;

           if($primeiro < 2 )
           {
               $primeiro = 0;
           }else{
               $primeiro = 11 - $primeiro;
           }

           if($value[12]!= $primeiro){
               return false;
           } 
             
    
    
           $segundo =
           ($value[0] * 6 
           + $value[1] * 5 
           + $value[2] * 4 
           + $value[3] * 3
           + $value[4] * 2
           + $value[5] * 9
           + $value[6] * 8
           + $value[7] * 7
           + $value[8] * 6
           + $value[9] * 5
           + $value[10] * 4
           + $value[11] * 3
           + $value[12] * 2
           
           ) % 11;
    
           if($segundo < 2){
               $segundo = 0;
           }else{
               $segundo = 11 - $segundo;
           }

           if($segundo != $value[13]){
              return false;
           } 
    
           return true;   

    }


}