<?php

namespace App\Providers;

use Illuminate\Support\Facades\Event;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        'App\Events\Event' => [
            'App\Listeners\EventListener',
        ],

        'App\Events\AddFotoUserEvent' => [
            'App\Listeners\AddFotoUserEventListener',
        ],

        'App\Events\AddDestinoEvent' => [
            'App\Listeners\AddDestinoEventListener',
        ],

        'App\Events\AddOrigemEvent' => [
            'App\Listeners\AddOrigemEventListener',
        ],

        'App\Events\UpdateDestinoEvent' => [
            'App\Listeners\UpdateDestinoEventListener',
        ],

        'App\Events\UpdateOrigemEvent' => [
            'App\Listeners\UpdateOrigemEventListener',
        ],   

        'App\Events\AddDocsEvent' => [
            'App\Listeners\AddDocsEventListener',
        ],          

        'App\Events\AddParecerEvent' => [
            'App\Listeners\AddParecerEventListener',
        ],  

        'App\Events\AddHistoricoEvent' => [
            'App\Listeners\AddHistoricoEventListener',
        ],   

        'App\Events\SetPermissionEvent' => [
            'App\Listeners\SetPermissionEventListener',
        ], 


        'App\Events\SetDocsComunicationEvent' => [
            'App\Listeners\SetDocsComunicationEventListener',
        ], 


    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
