<?php

namespace App\Listeners;

use App\Events\UpdateOrigemEvent;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
Use App\Http\Controllers\OrigemController;

class UpdateOrigemEventListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    protected $data; 

    public function __construct(OrigemController $data)
    {
        $this->data = $data;
    }

    /**
     * Handle the event.
     *
     * @param  UpdateOrigemEvent  $event
     * @return void
     */
    public function handle(UpdateOrigemEvent $event)
    {
        $this->data->update($event->getData());
    }
}
