<?php

namespace App\Listeners;

use App\Events\UpdateDestinoEvent;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
Use App\Http\Controllers\DestinoController;

class UpdateDestinoEventListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    protected $data; 

    public function __construct(DestinoController $data)
    {
        $this->data = $data;
    }

    /**
     * Handle the event.
     *
     * @param  UpdateDestinoEvent  $event
     * @return void
     */
    public function handle(UpdateDestinoEvent $event)
    {
        $this->data->update($event->getData());
    }
}
