<?php

namespace App\Listeners;

use App\Events\AddOrigemEvent;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
Use App\Http\Controllers\OrigemController;

class AddOrigemEventListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */

    protected $data; 

    public function __construct(OrigemController $data)
    {
        $this->data = $data;
    }

    /**
     * Handle the event.
     *
     * @param  AddOrigemEvent  $event
     * @return void
     */
    public function handle(AddOrigemEvent $event)
    {
         $this->data->store($event->getData());
    }
}
