<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Rules\ValidaDocumento;


class TipoParecerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [ 
            'tipo'       => 'required|min:3|max:60',
        ];

      
    }

    public function messages()
    {
        return [
           'tipo.required'           => 'O campo tipo não pode estar vazio !',
           'tipo.min'                => 'Digite no minimo 3 caracteres no campo tipo !',
           'tipo.max'                => 'Digite no maximo 60 caracteres no campo tipo !',       
           
        
        ];


    
       
    }
}