<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;


class SetoresRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
        return [
            'setor'    => 'required|'.Rule::unique('setors')->ignore($request->all()['id']).'|max:100',
            'email'    => 'required|email|'.Rule::unique('setors')->ignore($request->all()['id']).'|max:50',
        
        ];
    }

    public function messages()
    {
        return [
           'setor.required'  => 'Digite o nome do setor !',
           'setor.unique'    => 'Já temos um setor com este nome cadastrado !',
           'setor.max'       => 'O nome do setor não pode ter mais de 100 caracteres !',

           'email.required'  => 'Digite o email do setor !',
           'email.unique'    => 'O Email já esta sendo utilizado !',
           'email.max'       => 'Digite no maximo 50 caracteres !',
           'email.email'     => 'Digite um email valido !',
        ];
    }
}
