<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;



class RastreamentoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
     
        return [ 
                 'solicitante'       => 'required|min:3|max:50',
                 'protocolo'         => 'required|size:10'
             
              ];
    }

    public function messages()
    {
        return [
                'solicitante.required'    => 'Digite o nome completo do solicitante !',
                'solicitante.min'         => 'Digite o nome completo do solicitante !',
                'solicitante.max'         => 'Digite no maximo 50 caracteres !',
                
                'protocolo.required'     => 'Digite o número do protocolo  !',
                'protocolo.size'          => 'Digite o número do protocolo corretamente !',
           ];
    }
}