<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Rules\ValidaDocumento;


class ProcessoRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        //$id =   $this->route('id');

      

        return [ 
          //             'protocolo'        => 'unique:processes,protocolo,' . $id, 
                       'usuario_id'       => 'required|integer|min:1', 
                       'solicitante_id'   => 'required|integer|min:1',
                       'tipo_processo_id' => 'required|integer|min:1',
                       'criacao'          => 'required',
                       'alteracao'        => 'required',
                       'status_id'        => 'required',
                       'prazo'            => 'required',
                       'prioridade_id'    => 'required',                    
                       ///'tipo_parecer'    => 'required',
                       
                    //   'setor_id'         => 'required'
                     
                ];
    }

    public function messages()
    {
        return [
      //     'protocolo.unique'            => 'Não foi prossivel criar processo, sistema sobrecarregado, tente navamente',
           'usuario_id.required'         => 'Selecione o usuario !',
           'solicitante_id.required'     => 'Selecione o solicitante !',
           'solicitante_id.min'          => 'Selecione o solicitante !',
       //    'tipo_processo_id.required'   => 'Selecine o campo tipo de processo !',
           'protocolo.required'          => 'O número do protocolo não pode estar vazio !',
           'recebimento.required'        => 'O número do codigo de recebimento não pode estar vazio !',
           'criacao.required'            => 'A data da criação não pode estar vazia !',
           'alteracao.required'          => 'A data Alteração não pode estar vazia !',
           'status_id.required'          => 'Selecione o campo status !',
           'prioridade_id.required'      => 'Selecione o campoo prioridade !',   
           'prazo.required'              => 'Determine o prazo máximo para a tramitação do processo',
           'tipo_parecer.required'       => 'Selecione o campo tipo de parecer !',
          
        ];
    }
}