<?php

namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Rules\ValidaDocumento;


class PrioridadesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        
           
       
     
        return [ 'prioridade'       => 'required|min:3|max:15', ];
    }

    public function messages()
    {
        return [
           'prioridade.required'    => 'O campo prioridade não pode estar vazio !',
           'prioridade.min'         => 'Digite no minimo 3 caracteres !',
           'prioridade.max'         => 'Digite no maximo 15 caracteres!',        
        ];
    }
}