<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PasswordRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        
        return [
            'password'   => 'required|between:4,20|same:password_confirm',
                        
        ];
    }

    public function messages()
    {
        return [
    
           'password.required'   => 'Preencha o campo senha  !',
           'password.between'    => 'A senha deve ter no minimo 4 caracteres e no maximo 20 caracteres !',
           'password.same'       => 'Os campo senha e confirma senha devem ter o mesmo conteudo !',
     
        ];
    }
}
