<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;


class ParecerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */

    
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules(Request $request)
    {
      
        $rules = [
           'processes_id'     => 'required|numeric',
           'user_id'          => 'required|numeric',   
           'tipo_parecer_id'  => 'required|numeric',
           'setor_id'         => 'required|numeric',
           'titulo'           => 'required|max:45',
           'parecer'          => 'required',
           'documentos'       => 'between:0,3',
         ];

      
        
        if(isset($request->all()['documentos'])){     
          foreach ($request->all()['documentos'] as $key => $document) {
            $rules['documentos.'.$key]  = 'mimes:pdf';
           }
        }
     
    
        return $rules;

    }

    public function messages()
    {
        $rules =  [
           'processes_id.numeric'     => 'Número do processo não encotrado , volte a lista de processos !',
           'user_id.numeric'          => 'Usuario não encontrdo você não esta logado !',
           'tipo_parecer_id.numeric'  => 'Selecione o Tipo de Parecer !',
           'setor_id.numeric'         => 'Selecione o Setor !',
           'titulo.required'          => 'Digite o Titulo do Parecer',
           'titulo.max'               => 'Digite no Maximo  45 Caracteres',
           'parecer.required'         => 'Digite o Parecer !',
           'documentos.size'          => 'Faça o Uplaod de No maximo 3 arquivos',
           'documentos.0.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.1.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.2.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.3.mimes'       => 'Tipo de arquivo incopativel !',
           'documentos.4.mimes'       => 'Tipo de arquivo incopativel !',
        ];


       
          return $rules;
    }
}
