<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Fpdf;
use App\Events\AddHistoricoEvent as AddHistoricoEvent;

use \App\Process;


class ProcessosController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $status  = $request->all()['status'] ??  '0';
        $user_id = $request->all()['user_id'] ?? '0';


       
        $setores =  (\App\User::findOrFail($user_id))->Setors;


        $itens = DB::table('processes')
                ->join('soliciters',             'soliciters.id',     '=', 'processes.solicitante_id')
                ->join('setors',                 'setors.id',         '=', 'processes.setor_id')   
                ->join('tipo_processos',         'tipo_processos.id', '=', 'processes.tipo_processo_id')   
                ->join('status',                 'status.id',         '=', 'processes.status_id')     
                ->join('users',                  'users.id',          '=', 'processes.usuario_id')                 
                ->select('processes.id',
                        'processes.setor_id',
                        'setors.setor',
                        'processes.status_id',
                        'status.status',
                        'processes.tipo_processo_id',
                        'tipo_processos.tipo',
                      //  'users.name',
                        'processes.protocolo',
                        'processes.criacao',
                        'processes.prioridade_id',
                        'processes.tipo_processo_id',
                        'processes.tipo_parecer',
                        'parecer',
                        'processes.alteracao',
                        'soliciters.nome')
                        ->orderBy('processes.status_id', 'desc')
                        ->orderBy('processes.id', 'desc')
                        ->get();

       

             return   $this->setShow( $itens,$setores);
     
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        
//
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Process $process)
    {
        $process->update($request->all());
        return  $this->addHistoricoInterno($process);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    private function addHistoricoInterno($process){

         
        $request = new Request();
        $request['processes_id']       =  $process->id;
        $request['titulo']             =  'PROCESSO ATUALIZADO';
        
  //      $request['evento']             =  (' Status '  .  utf8_encode(\App\Status::findOrFail($process->status_id)->status ).
    //        ', Setor  ' . utf8_encode(\App\Setor::findOrFail($process->setor_id)->setor))  . 
      //      ', Código de recebimento Nº: '    .  utf8_encode(\App\Process::getRecebido()) ; 
            
            $request['evento']             =  (' Status '  .  (\App\Status::findOrFail($process->status_id)->status ).
            ', Setor  ' . (\App\Setor::findOrFail($process->setor_id)->setor))  . 
            ', Código de recebimento Nº: '    .  (\App\Process::getRecebido()) ; 
        
       
         
       
       
        return  (\Event::fire(new AddHistoricoEvent($request)));
    }
 

    private function setShow($itens,$setores){

        $processos = [];

        foreach ($itens as $k => $item) {
            
            $item->show = false;
            foreach ($setores as $y => $setor) {
                 if($item->setor_id == $setor->id){
                        $item->show = true;  
                  }
            }
            $processos[] =  $item;
        }

        return $processos;
    } 
}
