<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Events\AddFotoUserEvent as FotoEvent;
use App\Events\SetPermissionEvent as SetPermissionEvent;

use App\User;


class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
 
        $users =  User::paginate(3);
        return view('user.lista')->with(compact('users'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       
        return view('user.cadastra');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(\App\Http\Requests\UserRequest $request)
    {
        $request['password'] = bcrypt(substr (str_replace(' ','',$request->all()['name']),0,4));
        $user =  User::create($request->all());

        if(isset($request->all()['foto'])){
            $data = ['id'   => $user->id,
                     'foto' => $request->all()['foto'],
                     'pasta' => 'users'];
            \Event::fire(new FotoEvent($data));
        }
 
        if(isset($request->all()['adicionar'])){
            $user->Setors()->attach($request->all()['adicionar']);
        }

        \Event::fire(new SetPermissionEvent($user->id));

       return redirect()->route('usuario.index')->with('success', 'Dados cadastrados com sucesso !');
    } 

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user = User::findOrFail($id);     
        
       
        return view('user.atualiza')->with(compact('user'));


        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */




    public function update(\App\Http\Requests\UserRequest $request,$id)
    {
     
      // if($request->all()['status'] = '2')
      // {
            // dd($request->all());

      // }
      
       $user = User::findOrfail($id);
     
        $user->update($request->all());
        


        
        
        if(isset($request->all()['foto'])){
            $data = ['id'   => $id,
                    'foto' => $request->all()['foto'],
                    'pasta' => 'users'];
            
            \Event::fire(new FotoEvent($data));
        }
        
        
        if(isset($request->all()['remover'])){
            $user->Setors()->detach($request->all()['remover']);
        }
        
        if(isset($request->all()['adicionar'])){
            $user->Setors()->attach($request->all()['adicionar']);
        }
        
     //   dd($user);
        
        return redirect()->back()->with('success', 'Dados atualizados com sucesso !');
        
//        return redirect()->route('usuario.index')->with('success', 'Dados cadastrados com sucesso !');   
        
    }
    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function senha(\App\Http\Requests\SenhaRequest $request){
            $request['password'] =  bcrypt($request->all()['senha']);
            $user = User::findOrfail($request->all()['id']);
            $user->update($request->all());
            return redirect()->back()->with('success', 'Senha atualizada com sucesso !');

   
    }
}
