<?php

namespace App\Http\Controllers;

//use Illuminate\Http\Request;
use Illuminate\Http\Request;
use App\Events\AddFotoUserEvent as FotoEvent;
use \App\Setor;

class SetorController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
       $setores = Setor::paginate(3);
       return view('setor.lista')->with(compact('setores'));
      
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('setor.cadastra');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(\App\Http\Requests\SetoresRequest $request    )
    {

        $setor =  Setor::create($request->all());

        if(isset($request->all()['foto'])){
            $data = ['id'   => $setor->id,
                     'foto' => $request->all()['foto'],
                     'pasta' => 'setors'];
                     
            \Event::fire(new FotoEvent($data));
        }


        
        if(isset($request->all()['adicionar'])){
            $setor->Users()->attach($request->all()['adicionar']);
        }

        
        //return redirect()->back()->with('success', 'Dados cadastrados com sucesso !');
        return redirect()->route('setor.index')->with('success', 'Dados cadastrados com sucesso !'); 

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $setor = Setor::findOrFail($id);     
        return view('setor.atualiza')->with(compact('setor'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(\App\Http\Requests\SetoresRequest $request, $id)
    {
    


        $setor = Setor::findOrfail($id);
        $setor->update($request->all());
        
        if(isset($request->all()['foto'])){
            $data = ['id'    => $id,
                     'foto'  => $request->all()['foto'],
                     'pasta' => 'setors'];

            \Event::fire(new FotoEvent($data));
        }
        
        if(isset($request->all()['remover'])){
            $setor->Users()->detach($request->all()['remover']);
        }

        if(isset($request->all()['adicionar'])){
              $setor->Users()->attach($request->all()['adicionar']);
        }
      
//        return redirect()->back()->with('success', 'Dados atualizados com sucesso !');
        return redirect()->route('setor.index')->with('success', 'Dados cadastrados com sucesso !'); 

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
