<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Fpdf;

use File;
use Response;
use App\Parecer;

class ParecerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {


    ///    dd($request->all());
         
         
        $id =  $request['id'] ?? 0;
         
                

        $response  =  (DB::table('parecer')
        ->join('processes','parecer.processes_id','=','processes.id' )
        ->join('setors','setors.id','=','processes.setor_id')
        ->join('tipo_parecer','tipo_parecer.id','=','parecer.tipo_parecer_id')
        ->join('users','users.id','=','parecer.user_id')
        ->join('soliciters','soliciters.id','=','processes.solicitante_id')
        ->select( 'parecer.id','processes.protocolo','tipo_parecer.tipo','setors.setor','users.name','parecer.titulo','parecer.parecer','parecer.data','soliciters.nome')
        ->where('processes_id','like', $id ))
        ->get();




      $response->map(function($item){

            $item->docs = (DB::table('docs_parecer')        
                 ->select( 'id','name','extencao')
                 ->where('processes_id','like', $item->id))
                 ->get();


      });

     


       if($response->first()== null)
       {
          return view('parecer.registra')->with(compact('id'));
       } 

       return view('parecer.exibe')->with(compact('response','id')); 
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {

      
   

        return view('parecer.registra')->with(compact('id'));
    
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */

   


    public function store(\App\Http\Requests\ParecerRequest $request)
    {   
           $request['data']  = (new Carbon())->format('Y-m-d');
           $result =  Parecer::create($request->all());


           if(isset($request->all()['documentos'])){
               $this->setDocs($request,$result->id); 
           }

         //  return redirect()->back();
         return redirect()->back()->with('success', 'Dados Cadastrados com sucesso !');
    }


    public function show(Request $request){    
        
         dd($request->all());
      
    } 


       /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $parecer = Parecer::findOrFail($id);     
        return view('parecer.atualiza')->with(compact('parecer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(\App\Http\Requests\ParecerRequest $request, $id)
    {


        
        $parecer = Parecer::find($id);
        
       // dd($parecer);

        $parecer->update($request->all());

        
        if(isset($request->all()['documentos'])){
            $this->setDocs($request,$parecer->id); 
        }
      //  return view('parecer.atualiza')->with(compact('parecer'));

        return redirect()->back()->with('success', 'Dados atualizados com sucesso !');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }





   

 
    public function setDocs($request,$id)
    {       

     //   dd($request->all());
        foreach ($request->all()['documentos'] as $key => $value) {
          if ($request->hasFile('documentos') && $request->file('documentos')[$key]->isValid()) {            
            if(($value->getSize()) <= 999999 ){   
              if($value->extension() ==  'pdf'){
                
                    $doc = new \App\DocsParecer();
                    $doc->processes_id = $id;
                    $doc->name         = $value->getClientOriginalName();
                    $doc->extencao     = $value->extension();
                    $doc->save();  
                    $value->storeAs('public/images/documentos/parecer/', $doc->id .'.'.  $doc->extencao  );

                }
              }
           }
        }
    }

  


    public function getDocs(Request $request){        
       
               $path = (  base_path() . '/storage/app/public/images/documentos/parecer/'. $request->all()['id']   . '.' . $request->all()['extencao']);
     
          
               if (!File::exists($path)) {
                   abort(404);
               }
           
               $file = File::get($path);
               $type = File::mimeType($path);
               
               $response = Response::make($file, 200);
               $response->header("Content-Type", $type);
           
               return $response;

    } 

    public function removeDocs(Request $request){   
        
        
       
        $extencao =   $request->all()['extencao'] ;
              
        $doc =   \App\DocsParecer::find($request->all()['id']);
       
        //dd($doc);

        $path = (  base_path() . '/storage/app/public/images/documentos/parecer/'. $request->all()['id'] . '.'. $extencao );

       // dd($path);

        if (!File::exists($path)) {
            abort(404);
        }

        File::delete($path);
          
        $doc->delete(); 
               
        return redirect()->back();
    } 


    public function print($id){

             
      
      
      $parecer =    Parecer::find($id);
      
      
      $pagina = [substr($parecer->parecer,0,2800)];
      
      if (strlen($parecer->parecer) > 2800){
        
        foreach ( (str_split((substr($parecer->parecer,2800,strlen($parecer->parecer))),4400)) as $key => $value) {
          
          $pagina[] = $value;
          
        }
      }
      
      //dd($pagina);
   
   
      //str_split($parecer->parecer,2800); 

      
     // $pagina   =    str_split($parecer->parecer,2800); 


      
        \Fpdf::AddPage();
         
        \Fpdf::SetTitle('Prefeitura Municipal De Conceição do Coité',true);
     //  \Fpdf::SetTitle('Prefeitura Municipal De Santa Barbara',true);
      
       \Fpdf::SetMargins(0,0,0);      
       
        \Fpdf::Rect(15,15,185,32);
   
        \Fpdf::SetFillColor(200,200,200); 
  
        \Fpdf::Rect(15,47,185,5,'F');
  
        \Fpdf::Rect(145,15,55,32); 
        
        \Fpdf::Rect(15,65,185,5,'F');
  
        \Fpdf::Rect(15,47,35,18);
        \Fpdf::Rect(15,83,185,5,'F');
        \Fpdf::Rect(50,47,95,18);
        

        \Fpdf::Rect(15,101,185,5,'F');

        \Fpdf::Rect(145,47,55,18);
        
        \Fpdf::Rect(15,65,185,18); 
      
        \Fpdf::Rect(15,83,185,18); 
      
        \Fpdf::Rect(15,101,185,163);
     //   \Fpdf::Rect(15,264,185,5,'F');
      
       // \Fpdf::Rect(15,264,93,20);
       // \Fpdf::Rect(108,264,92,20);
  
        
        \Fpdf::SetFont('Arial', 'B', 13);
        \Fpdf::Image( base_path() . '/public/images/brasao/brasao-relatorio.png',17,17,25,25);
        \Fpdf::SetXY(0,10);
        \Fpdf::Cell(190,40,utf8_decode('Prefeitura Municipal De Conceição do Coité'),0,1,'C');
      //  \Fpdf::Cell(190,40,utf8_decode('Prefeitura Municipal de Conceição do Coité'),0,1,'C');
        
      \Fpdf::SetFont('Arial', 'B', 15);
      
      \Fpdf::SetXY(145,25);
      \Fpdf::Cell(55,5,'PARECER',0,1,'C');
      \Fpdf::SetXY(145,30);
      \Fpdf::Cell(55,5, "ID/" . str_pad($parecer->id,8,'0',STR_PAD_LEFT),0,1,'C');
      
      \Fpdf::SetXY(155,32);
      
      \Fpdf::SetFont('Arial', 'B', 10);
      
      \Fpdf::SetXY(15,47.3);
      \Fpdf::Cell(35,5,utf8_decode('Nº Processo'),0,1,'L');
      
      \Fpdf::SetXY(50,47.3);
      \Fpdf::Cell(90,5,utf8_decode('Parecer dado por'),0,1,'L');
      
      
      \Fpdf::SetXY(145,47.3);
      \Fpdf::Cell(55,5,utf8_decode('Data do Parecer'),0,1,'L');
      
      \Fpdf::SetXY(15,65.2);
      \Fpdf::Cell(45,5,utf8_decode('Tipo de Parecer'),0,1,'L');
      
      \Fpdf::SetXY(15,83.3);
      \Fpdf::Cell(45,5,utf8_decode('Titulo'),0,1,'L');
      
      
      \Fpdf::SetXY(15,100.5);
      \Fpdf::Cell(45,5,utf8_decode('Parecer'),0,1,'L');
      
     // \Fpdf::SetXY(15,264);
      //\Fpdf::Cell(93,5,utf8_decode('Assinatura do Solicitante'),0,1,'L');
      
      
      //\Fpdf::SetXY(108,264);
      //\Fpdf::Cell(92,5,utf8_decode('Data de Recebimento'),0,1,'L');
      
      \Fpdf::SetFont('Arial', 'B', 12);
      \Fpdf::SetXY(15,55.3);
      \Fpdf::Cell(35,6,utf8_decode( \App\Process::findOrFail($parecer->processes_id)->protocolo ),0,2,'C');
      
      \Fpdf::SetXY(50,55.3);
      \Fpdf::Cell(95,6,utf8_decode(\App\User::find($parecer->user_id)->name ),0,2,'C');
      
      
      \Fpdf::SetXY(135,55.3);
      \Fpdf::Cell(65,6,utf8_decode(  date("d/m/Y", strtotime($parecer->data))                   ),0,2,'C');
      
      // 
      
       \Fpdf::SetFont('Arial', 'B', 10);
       \Fpdf::SetXY(15,72.3);
       \Fpdf::Cell(185,6,utf8_decode( \App\TipoParecer::find($parecer->tipo_parecer_id)->tipo ),0,2,'L');
      

       \Fpdf::SetFont('Arial', 'B', 12);
       \Fpdf::SetXY(15,91.3);
       \Fpdf::Cell(185,1,utf8_decode($parecer->titulo ),0,2,'L');
      

      // \Fpdf::SetFont('Arial', 'B', 20);
      // \Fpdf::SetXY(109,270.8);
      // \Fpdf::Cell(91,5,utf8_decode('....../......./........'),0,1,'C');

      // \Fpdf::SetFont('Arial', 'B', 8);
      // \Fpdf::SetXY(15,106);
     //  \Fpdf::MultiCell(185,6,utf8_decode(     $this->limita_caracteres($texto,2800,true)     ),0,'J');
      
     


       foreach ($pagina as $key => $page) {
        
        \Fpdf::SetFont('Arial', 'B', 8);
        \Fpdf::SetXY(15,106);

           if($key > 0){
              \Fpdf::AddPage();
              \Fpdf::SetXY(15,15.8);
              \Fpdf::Rect(15,10,185,255);
              \Fpdf::SetXY(15,15);
        
            }
   //  dd($page);

   
   
   \Fpdf::MultiCell(185,6,utf8_decode(   $page      ),0,'J');
          if($key == (count($pagina)-1)){
                  \Fpdf::Rect(15,264,185,5,'F');
                  \Fpdf::Rect(15,264,93,20);
                  \Fpdf::Rect(108,264,92,20);
                  \Fpdf::SetXY(108,264);
                  \Fpdf::Cell(92,5,utf8_decode('Data de Recebimento'),0,1,'L');
                  
                  
                  \Fpdf::SetXY(15,264);
                  \Fpdf::Cell(93,5,utf8_decode('Assinatura do Responsavel'),0,1,'L'); 
                  \Fpdf::SetFont('Arial', 'B', 20);
                  \Fpdf::SetXY(109,270.8);
                  \Fpdf::Cell(91,5,utf8_decode('....../......./........'),0,1,'C');
           }
      
      
      
        }


         
       

     
      
      
        \Fpdf::Output();  
      
        exit;
  
      
  











    }




  


}


