<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use File;
use Response;

use \App\Documento;

class DocumentoController extends Controller
{
   
    public function store(Request $request){       
        foreach (($request->all()['documentos']) as $key => $value) {
            if ($request->hasFile('documentos') && $request->file('documentos')[$key]->isValid()) {            
                if(($value->getSize()) <= 99999999 ){
                    $doc = new Documento();
                    $doc->processes_id = $request->all()['id'];
                    $doc->documento   = $value->getClientOriginalName();
                    $doc->extencao    = $value->extension() ;
                    $doc->save();  
                    $value->storeAs('public/images/documentos/', $doc->id .'.'.  $doc->extencao  );
               }
            }
        }     
    }

    public function show($id){        
        $path = (  base_path() . '/storage/app/public/images/documentos/'. $id);

        if (!File::exists($path)) {
            abort(404);
        }
    
        $file = File::get($path);
        $type = File::mimeType($path);
        
        $response = Response::make($file, 200);
        $response->header("Content-Type", $type);
    
        return $response;
    } 

    public function update(Request $request){
      

         $arquivo =   (Documento::find($request->all()['id']));



         $arquivo->documento = $request->all()['documento'] . $request->all()['extencao'];
         $arquivo->save();
         return redirect()->back();
    }


    public function remove(Request $request){

        $arquivo  =   (Documento::find($request->all()['id']));
        $extencao =  $request->all()['extencao'] == '.jpg' ? '.jpeg' : $request->all()['extencao'] ;

        $path = (  base_path() . '/storage/app/public/images/documentos/'. $request->all()['id'] .  $extencao );

        //dd($path);

        if (!File::exists($path)) {
            abort(404);
        }

        File::delete($path);
          
        $arquivo->delete(); 
               
        return redirect()->back();
       
    }

}
