<?php

namespace App\Http\Controllers;

use App\Comunicacao;
use Illuminate\Http\Request;
use App\Events\SetDocsComunicationEvent;
use Validator;

class ComunicacaoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

           

        $enviadas      =  (Comunicacao::join('users','users.id','LIKE','mensagens.usuario_id')
                          ->join('setors','setors.id','LIKE','mensagens.setor_id')
                          ->join('tipos_comunicacao','tipos_comunicacao.id','LIKE','mensagens.tipos_comunicacao_id')
                          ->select('mensagens.id','mensagens.numero','users.name','setors.setor','titulo','tipos_comunicacao.tipo')
                          ->where('mensagens.usuario_id','LIKE',auth()->user()->id))
                          ->get();


        $recebidas     =  (Comunicacao::join('receptores','receptores.mensagem_id','LIKE','mensagens.id')
                          ->join('users','users.id','LIKE','mensagens.usuario_id')
                          ->join('setors','setors.id','LIKE','mensagens.setor_id')
                          ->join('tipos_comunicacao','tipos_comunicacao.id','LIKE','mensagens.tipos_comunicacao_id')
                          ->select('mensagens.id','mensagens.numero','users.name','setors.setor','titulo','tipos_comunicacao.tipo')
                          ->where('receptores.status','LIKE','ABERTO')
                          ->where('receptores.user_id','LIKE',auth()->user()->id))
                          ->get();
      
        $visuaizados     = (Comunicacao::join('receptores','receptores.mensagem_id','LIKE','mensagens.id')
                          ->join('users','users.id','LIKE','mensagens.usuario_id')
                          ->join('setors','setors.id','LIKE','mensagens.setor_id')
                          ->join('tipos_comunicacao','tipos_comunicacao.id','LIKE','mensagens.tipos_comunicacao_id')
                          ->select('mensagens.id','mensagens.numero','users.name','setors.setor','titulo','tipos_comunicacao.tipo')
                          ->where('receptores.status','LIKE','FECHADO')
                          ->where('receptores.user_id','LIKE',auth()->user()->id))
                          ->get();


    

        return view('comunicacao.lista')->with(compact('enviadas','recebidas','visuaizados'));
  
    }

    public function verifica($id){


      $comunicacao =  \App\Receptor::join('users','users.id','LIKE','receptores.user_id')
                              ->select('receptores.id','name','receptores.status')
                              ->where('mensagem_id','LIKE',$id)->get();
                     

        return view('comunicacao.verifica')->with(compact('comunicacao'));

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
 
           

        return view('comunicacao.cadastra');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(\App\Http\Requests\ComunicacaoRequest $request)
    {
        
      //  dd($request->all());
         
        $request['numero'] = \App\Comunicacao::getNumeroMensagem();

        $result = Comunicacao::create($request->all());
        $this->envia($request->all()['receptores'],$result->id);
 
        if( isset($request->all()['documentos'])){
             $this->arquivos($request->all()['documentos'],$result->id);   
        }
         

    broadcast(new \App\Events\NotificationEvent(['mensagem'=>'criada','receptores'=>$request->all()['receptores']]));

        return view('comunicacao.cadastra');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Comunicacao  $comunicacao
     * @return \Illuminate\Http\Response
     */
    public function show(Comunicacao $comunicacao)
    {
      


    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Comunicacao  $comunicacao
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {



        $comunicacao = Comunicacao::findOrFail($id);

        return view('comunicacao.atualiza')->with(compact('comunicacao'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Comunicacao  $comunicacao
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
       //dd($request->all());

        $messages = [
            'status.required' => 'Assinale a opção que indica a leitura da C.I. ',
        ];

        $validator = Validator::make($request->all(), ['status' => 'required'],$messages);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator);
        }

          
        \App\Receptor::where('mensagem_id','LIKE',$request->all()['mensagem_id'])
                     ->where('user_id','LIKE',$request->all()['user_id'])
                     ->update(['status' => 'FECHADO']);

        $sucess = ['C.I marcada como lida !'];


      broadcast(new \App\Events\NotificationEvent(['mensagem'=>'atualizada','receptores'=>'']));

        return redirect()->back()->with(compact('sucess'));         

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Comunicacao  $comunicacao
     * @return \Illuminate\Http\Response
     */
    public function destroy(Comunicacao $comunicacao)
    {
        //
    }


    private function envia($receptores,$mensagem_id){

        foreach ($receptores as $key => $receptor) {

          $receptor = [
              'mensagem_id' => $mensagem_id,
              'user_id'     => $receptor,
              'status'      => 'ABERTO'
          ]; 

          \App\Receptor::create($receptor);
        }

    }

    private function arquivos($arquivos,$mensagem_id){

       
       foreach ($arquivos as $key => $arquivo) {
           
           $data = [
               'mensagem_id' => $mensagem_id,
               'arquivo'     => $arquivo,
            ];
            
            \Event::fire(new SetDocsComunicationEvent($data));

           
        }
        
     
    }

}
